//------------------------------------------------------------------
// not for sale, rent, auction, nor lease
// https://forex-station.com/viewtopic.php?f=579496&t=8466839&start=90
#property copyright "mladen"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrRed
#property indicator_color3  clrLimeGreen
#property indicator_color4  clrRed
#property indicator_color5  clrLimeGreen
#property indicator_color6  clrRed
#property indicator_color7  clrLimeGreen
#property indicator_color8  clrRed
#property indicator_minimum 0
#property indicator_maximum 5

//33 enPrices
enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_tbiased2,   // Trend biased (extreme) price
   pr_haclose,    // Heiken ashi close
   pr_haopen,     // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased,  // Heiken ashi trend biased price
   pr_hatbiased2, // Heiken ashi trend biased (extreme) price
   pr_habclose,   // Heiken ashi (better formula) close
   pr_habopen,    // Heiken ashi (better formula) open
   pr_habhigh,    // Heiken ashi (better formula) high
   pr_hablow,     // Heiken ashi (better formula) low
   pr_habmedian,  // Heiken ashi (better formula) median
   pr_habtypical, // Heiken ashi (better formula) typical
   pr_habweighted,// Heiken ashi (better formula) weighted
   pr_habaverage, // Heiken ashi (better formula) average
   pr_habmedianb, // Heiken ashi (better formula) median body
   pr_habtbiased, // Heiken ashi (better formula) trend biased price
   pr_habtbiased2 // Heiken ashi (better formula) trend biased (extreme) price
};

extern string TimeFrame1              = "Current time frame";
extern string TimeFrame2              = "next1";
extern string TimeFrame3              = "next2";
extern string TimeFrame4              = "next3";

extern enPrices     Price                   = pr_close;         // Price to use for SATL calculation
extern string       UniqueID                = "4TF SATL";
extern int          LinesWidth              = 0;
extern color        LabelsColor             = clrDarkGray;
extern int          LabelsHorizontalShift   = 5;
extern double       LabelsVerticalShift     = 1.5;
extern bool         alertsOn                = false;
extern string       note1                   = "alertsLevel=3 means 3 time frames are aligned in the same direction";
extern int          alertsLevel             = 3;
extern bool         alertsMessage           = false;
extern bool         alertsSound             = false;
extern bool         alertsEmail             = false;
extern int          WingdingsFontCode1      = 110;
extern int          WingdingsFontCode2      = 110;
extern int          WingdingsFontCode3      = 108;
extern int          WingdingsFontCode4      = 108;
extern int          MaximumCandlesToDisplay = 287;

double ForexStationSATL1u[], ForexStationSATL1d[], ForexStationSATL2u[], ForexStationSATL2d[], ForexStationSATL3u[], ForexStationSATL3d[], ForexStationSATL4u[], ForexStationSATL4d[],prices[];

int    timeFrames[4];
bool   returnBars, calculateValue;
string indicatorFileName;

//------------------------------------------------------------------
int OnInit()
{
      IndicatorBuffers(9);
      SetIndexBuffer(0,ForexStationSATL1u);
      SetIndexBuffer(1,ForexStationSATL1d);
      SetIndexBuffer(2,ForexStationSATL2u);
      SetIndexBuffer(3,ForexStationSATL2d);
      SetIndexBuffer(4,ForexStationSATL3u);
      SetIndexBuffer(5,ForexStationSATL3d);
      SetIndexBuffer(6,ForexStationSATL4u);
      SetIndexBuffer(7,ForexStationSATL4d);
      SetIndexBuffer(8,prices); 

      indicatorFileName = WindowExpertName();
      returnBars        = (TimeFrame1=="returnBars");     if (returnBars)     return(0);
      calculateValue    = (TimeFrame1=="calculateValue"); if (calculateValue) return(0);
      
      SetIndexStyle(0,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(0,WingdingsFontCode1); 
      SetIndexStyle(1,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(1,WingdingsFontCode1); 
      SetIndexStyle(2,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(2,WingdingsFontCode2); 
      SetIndexStyle(3,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(3,WingdingsFontCode2); 
      SetIndexStyle(4,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(4,WingdingsFontCode3); 
      SetIndexStyle(5,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(5,WingdingsFontCode3); 
      SetIndexStyle(6,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(6,WingdingsFontCode4); 
      SetIndexStyle(7,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(7,WingdingsFontCode4); 

      timeFrames[0] = stringToTimeFrame(TimeFrame1);
      timeFrames[1] = stringToTimeFrame(TimeFrame2);
      timeFrames[2] = stringToTimeFrame(TimeFrame3);
      timeFrames[3] = stringToTimeFrame(TimeFrame4);

      alertsLevel = MathMin(MathMax(alertsLevel,3),indicator_buffers/2);
      IndicatorShortName(UniqueID);
      return(0);
}
//------------------------------------------------------------------
int deinit()
{
   for (int t=0; t<indicator_buffers/2; t++) ObjectDelete(UniqueID+t);
   return(0); 
}
//------------------------------------------------------------------
double trend[][2];
#define _up 0
#define _dn 1
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { ForexStationSATL1u[0] = limit+1; return(0); }
         if (calculateValue) { calculateSATL(limit); return(0); }

         if (timeFrames[0] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,"returnBars",0,0)*timeFrames[0]/Period()));
         if (timeFrames[1] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,"returnBars",0,0)*timeFrames[1]/Period()));
         if (timeFrames[2] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,"returnBars",0,0)*timeFrames[2]/Period()));
         if (timeFrames[3] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,"returnBars",0,0)*timeFrames[3]/Period()));
         limit = MaximumCandlesToDisplay;
         if (ArrayRange(trend,0)!=Bars) ArrayResize(trend,Bars);
         
         bool initialized = false;
         if (!initialized)
         {
            initialized = true;
            int window = WindowFind(UniqueID);
            for (int t=0; t<indicator_buffers/2; t++)
            {
               string label = timeFrameToString(timeFrames[t]);
               ObjectCreate(UniqueID+t,OBJ_TEXT,window,0,0);
               ObjectSet(UniqueID+t,OBJPROP_COLOR,LabelsColor);
               ObjectSet(UniqueID+t,OBJPROP_PRICE1,t+LabelsVerticalShift);
               ObjectSetText(UniqueID+t,label,8,"Arial");
            }               
         }
         for (t=0; t<indicator_buffers/2; t++) ObjectSet(UniqueID+t,OBJPROP_TIME1,Time[0]+Period()*LabelsHorizontalShift*60);
    
   for(i = limit, r=Bars-i-1; i >= 0; i--,r++)
   {
      trend[r][_up] = 0;
      trend[r][_dn] = 0;
      for (int k=0; k<indicator_buffers/2; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
            double ForexStationSATL = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",0,y);
            bool   isUp   = (ForexStationSATL > iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",0,y+1));
            switch (k)
            {
               case 0 : if (isUp) { ForexStationSATL1u[i] = k+1; ForexStationSATL1d[i] = EMPTY_VALUE;}  else { ForexStationSATL1d[i] = k+1; ForexStationSATL1u[i] = EMPTY_VALUE; } break;
               case 1 : if (isUp) { ForexStationSATL2u[i] = k+1; ForexStationSATL2d[i] = EMPTY_VALUE;}  else { ForexStationSATL2d[i] = k+1; ForexStationSATL2u[i] = EMPTY_VALUE; } break;
               case 2 : if (isUp) { ForexStationSATL3u[i] = k+1; ForexStationSATL3d[i] = EMPTY_VALUE;}  else { ForexStationSATL3d[i] = k+1; ForexStationSATL3u[i] = EMPTY_VALUE; } break;
               case 3 : if (isUp) { ForexStationSATL4u[i] = k+1; ForexStationSATL4d[i] = EMPTY_VALUE;}  else { ForexStationSATL4d[i] = k+1; ForexStationSATL4u[i] = EMPTY_VALUE; } break;
            }
            if (isUp)
                  trend[r][_up] += 1;
            else  trend[r][_dn] += 1;
      }
   }
   manageAlerts();
   return(0);
}
//-------------------------------------------------------------------
void calculateSATL(int limit)
{

    for (int i=limit; i>=0; i--)
    {  
       prices[i] = getPrice(Price,Open,Close,High,Low,i,Bars);
            ForexStationSATL1u[i] = 
0.0982862174*prices[i+0] 
+0.0975682269*prices[i+1] 
+0.0961401078*prices[i+2] 
+0.0940230544*prices[i+3] 
+0.0912437090*prices[i+4] 
+0.0878391006*prices[i+5] 
+0.0838544303*prices[i+6] 
+0.0793406350*prices[i+7] 
+0.0743569346*prices[i+8] 
+0.0689666682*prices[i+9] 
+0.0632381578*prices[i+10] 
+0.0572428925*prices[i+11] 
+0.0510534242*prices[i+12] 
+0.0447468229*prices[i+13] 
+0.0383959950*prices[i+14] 
+0.0320735368*prices[i+15] 
+0.0258537721*prices[i+16] 
+0.0198005183*prices[i+17] 
+0.0139807863*prices[i+18] 
+0.0084512448*prices[i+19] 
+0.0032639979*prices[i+20] 
-0.0015350359*prices[i+21] 
-0.0059060082*prices[i+22] 
-0.0098190256*prices[i+23] 
-0.0132507215*prices[i+24] 
-0.0161875265*prices[i+25] 
-0.0186164872*prices[i+26] 
-0.0205446727*prices[i+27] 
-0.0219739146*prices[i+28] 
-0.0229204861*prices[i+29] 
-0.0234080863*prices[i+30] 
-0.0234566315*prices[i+31] 
-0.0231017777*prices[i+32] 
-0.0223796900*prices[i+33] 
-0.0213300463*prices[i+34] 
-0.0199924534*prices[i+35] 
-0.0184126992*prices[i+36] 
-0.0166377699*prices[i+37] 
-0.0147139428*prices[i+38] 
-0.0126796776*prices[i+39] 
-0.0105938331*prices[i+40] 
-0.0084736770*prices[i+41] 
-0.0063841850*prices[i+42] 
-0.0043466731*prices[i+43] 
-0.0023956944*prices[i+44] 
-0.0005535180*prices[i+45] 
+0.0011421469*prices[i+46] 
+0.0026845693*prices[i+47] 
+0.0040471369*prices[i+48] 
+0.0052380201*prices[i+49] 
+0.0062194591*prices[i+50] 
+0.0070340085*prices[i+51] 
+0.0076266453*prices[i+52] 
+0.0080376628*prices[i+53] 
+0.0083037666*prices[i+54] 
+0.0083694798*prices[i+55] 
+0.0082901022*prices[i+56] 
+0.0080741359*prices[i+57] 
+0.0077543820*prices[i+58] 
+0.0073260526*prices[i+59] 
+0.0068163569*prices[i+60] 
+0.0062325477*prices[i+61] 
+0.0056078229*prices[i+62] 
+0.0049516078*prices[i+63] 
+0.0161380976*prices[i+64]; 
             
     }
}
//-------------------------------------------------------------------
void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = Bars-1;
      if (trend[whichBar][_up] >= alertsLevel || trend[whichBar][_dn] >= alertsLevel)
      {
         if (trend[whichBar][_up] >= alertsLevel) doAlert("up"  ,trend[whichBar][_up]);
         if (trend[whichBar][_dn] >= alertsLevel) doAlert("down",trend[whichBar][_dn]);
      }
   }
}
//-------------------------------------------------------------------
void doAlert(string doWhat, int howMany)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[0]) {
       previousAlert  = doWhat;
       previousTime   = Time[0];

       message =  Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" "+howMany+" time frames of SATL are aligned "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(Symbol()+" 4TF SATL",message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}
//-------------------------------------------------------------------
string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

int toInt(double value) { return(value); }
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   int max = ArraySize(iTfTable)-1, add=0;
   int nxt = (StringFind(tfs,"NEXT1")>-1); if (nxt>0) { tfs = ""+Period(); add=1; }
       nxt = (StringFind(tfs,"NEXT2")>-1); if (nxt>0) { tfs = ""+Period(); add=2; }
       nxt = (StringFind(tfs,"NEXT3")>-1); if (nxt>0) { tfs = ""+Period(); add=3; }
         
      for (int i=max; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[toInt(MathMin(max,i+add))],Period()));
                                                      return(Period());
}
//-------------------------------------------------------------------
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
//-------------------------------------------------------------------
string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
//-------------------------------------------------------------------
#define _prHABF(_prtype) (_prtype>=pr_habclose && _prtype<=pr_habtbiased2)
#define _priceInstances     1
#define _priceInstancesSize 4
double workHa[][_priceInstances*_priceInstancesSize];
double getPrice(int tprice, const double& open[], const double& close[], const double& high[], const double& low[], int i, int bars, int instanceNo=0)
{
  if (tprice>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars); instanceNo*=_priceInstancesSize; int r = bars-i-1;
         
         double haOpen  = (r>0) ? (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0 : (open[i]+close[i])/2;;
         double haClose = (open[i]+high[i]+low[i]+close[i]) / 4.0;
         if (_prHABF(tprice))
               if (high[i]!=low[i])
                     haClose = (open[i]+close[i])/2.0+(((close[i]-open[i])/(high[i]-low[i]))*MathAbs((close[i]-open[i])/2.0));
               else  haClose = (open[i]+close[i])/2.0; 
         double haHigh  = fmax(high[i], fmax(haOpen,haClose));
         double haLow   = fmin(low[i] , fmin(haOpen,haClose));
         
         if(haOpen<haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else               { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                              workHa[r][instanceNo+2] = haOpen;
                              workHa[r][instanceNo+3] = haClose;
         
         switch (tprice)
         {
            case pr_haclose:
            case pr_habclose:    return(haClose);
            case pr_haopen:   
            case pr_habopen:     return(haOpen);
            case pr_hahigh: 
            case pr_habhigh:     return(haHigh);
            case pr_halow:    
            case pr_hablow:      return(haLow);
            case pr_hamedian:
            case pr_habmedian:   return((haHigh+haLow)/2.0);
            case pr_hamedianb:
            case pr_habmedianb:  return((haOpen+haClose)/2.0);
            case pr_hatypical:
            case pr_habtypical:  return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:
            case pr_habweighted: return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:  
            case pr_habaverage:  return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
            case pr_habtbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
            case pr_hatbiased2:
            case pr_habtbiased2:
               if (haClose>haOpen)  return(haHigh);
               if (haClose<haOpen)  return(haLow);
                                    return(haClose);        
         }
   }
   
   
   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
      case pr_tbiased2:   
               if (close[i]>open[i]) return(high[i]);
               if (close[i]<open[i]) return(low[i]);
                                     return(close[i]);        
   }
   return(0);
}
//-------------------------------------------------------------------
