// not for sale, rent, auction, nor lease
// 2020
//------------------------------------------------------------------
#property copyright "mladen RCI(9), RCI(26), and RCI(52)"
#property link      "www.forex-station.com"
//#property description ""
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrPaleVioletRed
#property indicator_color3  clrLimeGreen
#property indicator_color4  clrPaleVioletRed
#property indicator_color5  clrLimeGreen
#property indicator_color6  clrPaleVioletRed
#property indicator_color7  clrLimeGreen
#property indicator_color8  clrPaleVioletRed
#property indicator_minimum 0
#property indicator_maximum 5

extern string TimeFrame1            = "Current time frame";
extern string TimeFrame2            = "next1";
extern string TimeFrame3            = "next2";
extern string TimeFrame4            = "next3";
extern string UniqueID              = "4TF RCI SLOPE "; 
extern int    HowManyBarsToDisplay  = 100;
extern int    RCIperiod             = 9; //was 9, 26, 52
extern int    LinesWidth            = 0;
extern color  LabelsColor           = clrDarkGray;
extern int    LabelsHorizontalShift = 5;
extern double LabelsVerticalShift   = 1.5;
extern int    WingdingsFontSymbol1  = 110;
extern int    WingdingsFontSymbol2  = 110;
extern int    WingdingsFontSymbol3  = 108;
extern int    WingdingsFontSymbol4  = 108;

extern bool   alertsOn              = false;
extern int    alertsLevel           = 3;
extern bool   alertsMessage         = false;
extern bool   alertsSound           = false;
extern bool   alertsEmail           = false;
extern string note_a="input an integer for TimeFrame1 such as";
extern string note_b="1,5,15,30,60,240,1440,10080,43200, or leave as it is";

double hadelta1u[], hadelta1d[], hadelta2u[], hadelta2d[], hadelta3u[], hadelta3d[], hadelta4u[], hadelta4d[];
int    timeFrames[4];
bool   returnBars, calculateValue;
string indicatorFileName;
//------------------------------------------------------------------
int OnInit()
{
      SetIndexBuffer(0,hadelta1u);
      SetIndexBuffer(1,hadelta1d);
      SetIndexBuffer(2,hadelta2u);
      SetIndexBuffer(3,hadelta2d);
      SetIndexBuffer(4,hadelta3u);
      SetIndexBuffer(5,hadelta3d);
      SetIndexBuffer(6,hadelta4u);
      SetIndexBuffer(7,hadelta4d);
      for (int i=0; i<12; i++) 
         SetIndexStyle(i,DRAW_ARROW,EMPTY,LinesWidth);  

      SetIndexArrow(0,WingdingsFontSymbol1);
      SetIndexArrow(1,WingdingsFontSymbol1);
      SetIndexArrow(2,WingdingsFontSymbol2);
      SetIndexArrow(3,WingdingsFontSymbol2);
      SetIndexArrow(4,WingdingsFontSymbol3);
      SetIndexArrow(5,WingdingsFontSymbol3);
      SetIndexArrow(6,WingdingsFontSymbol4);
      SetIndexArrow(7,WingdingsFontSymbol4);     
      indicatorFileName = WindowExpertName();
      returnBars        = (TimeFrame1=="returnBars");     if (returnBars)     return(0);
      
      timeFrames[0] = stringToTimeFrame(TimeFrame1);
      timeFrames[1] = stringToTimeFrame(TimeFrame2);
      timeFrames[2] = stringToTimeFrame(TimeFrame3);
      timeFrames[3] = stringToTimeFrame(TimeFrame4);
      alertsLevel = MathMin(MathMax(alertsLevel,3),4);
      IndicatorShortName(UniqueID);
   return(0);
}
//------------------------------------------------------------------
int deinit()
{
   for (int t=0; t<4; t++) ObjectDelete(UniqueID+t);
   return(0); 
}
//------------------------------------------------------------------
double trend[][2];
#define _up 0
#define _dn 1
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { hadelta1u[0] = limit+1; return(0); }

         if (timeFrames[0] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,"returnBars",0,0)*timeFrames[0]/Period()));
         if (timeFrames[1] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,"returnBars",0,0)*timeFrames[1]/Period()));
         if (timeFrames[2] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,"returnBars",0,0)*timeFrames[2]/Period()));
         if (timeFrames[3] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,"returnBars",0,0)*timeFrames[3]/Period()));
         limit = HowManyBarsToDisplay;
         if (ArrayRange(trend,0)!=Bars) ArrayResize(trend,Bars);
         
         static bool initialized = false;
         if (!initialized)
         {
            initialized = true;
            int window = WindowFind(UniqueID);
            for (int t=0; t<4; t++)
            {
               string label = timeFrameToString(timeFrames[t]+ " (" + IntegerToString(RCIperiod) + ")");
               ObjectCreate (UniqueID+t,OBJ_TEXT,window,0,0);
               ObjectSet    (UniqueID+t,OBJPROP_COLOR,LabelsColor);
               ObjectSet    (UniqueID+t,OBJPROP_PRICE1,t+LabelsVerticalShift);
               ObjectSetText(UniqueID+t,label,8,"Arial");
               ObjectSet    (UniqueID+t,OBJPROP_TIME1,Time[0]+Period()*LabelsHorizontalShift*60);
            }               
         }
   
   for(i = limit, r=Bars-i-1; i >= 0; i--,r++)
   {
      trend[r][_up] = 0;
      trend[r][_dn] = 0;
      for (int k=0; k<4; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
            double yourRCI1 = iRCI(NULL,timeFrames[k],RCIperiod,y);
            double yourRCI2 = iRCI(NULL,timeFrames[k],RCIperiod,y+1);
            bool isUp = (yourRCI1>yourRCI2);

            switch (k)
            {
               case 0 : if (isUp) { hadelta1u[i] = k+1; hadelta1d[i] = EMPTY_VALUE;}  else { hadelta1d[i] = k+1; hadelta1u[i] = EMPTY_VALUE; } break;
               case 1 : if (isUp) { hadelta2u[i] = k+1; hadelta2d[i] = EMPTY_VALUE;}  else { hadelta2d[i] = k+1; hadelta2u[i] = EMPTY_VALUE; } break;
               case 2 : if (isUp) { hadelta3u[i] = k+1; hadelta3d[i] = EMPTY_VALUE;}  else { hadelta3d[i] = k+1; hadelta3u[i] = EMPTY_VALUE; } break;
               case 3 : if (isUp) { hadelta4u[i] = k+1; hadelta4d[i] = EMPTY_VALUE;}  else { hadelta4d[i] = k+1; hadelta4u[i] = EMPTY_VALUE; } break;
            }
            if (isUp)
                  trend[r][_up] += 1;
            else  trend[r][_dn] += 1;
      }
   }
   manageAlerts();
   return(0);
}
//+-------------------------------------------------------------------
void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = Bars-1;
      if (trend[whichBar][_up] >= alertsLevel || trend[whichBar][_dn] >= alertsLevel)
      {
         if (trend[whichBar][_up] >= alertsLevel) doAlert("up"  ,trend[whichBar][_up]);
         if (trend[whichBar][_dn] >= alertsLevel) doAlert("down",trend[whichBar][_dn]);
      }
   }
}
//+-------------------------------------------------------------------
void doAlert(string doWhat, int howMany)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[0]) {
       previousAlert  = doWhat;
       previousTime   = Time[0];

       message =  Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" "+howMany+" TF of RCI are aligned "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(Symbol()+" 4TF of RCI",message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}
//+-------------------------------------------------------------------
string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

int toInt(double value) { return(value); }
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   int max = ArraySize(iTfTable)-1, add=0;
   int nxt = (StringFind(tfs,"NEXT1")>-1); if (nxt>0) { tfs = ""+Period(); add=1; }
       nxt = (StringFind(tfs,"NEXT2")>-1); if (nxt>0) { tfs = ""+Period(); add=2; }
       nxt = (StringFind(tfs,"NEXT3")>-1); if (nxt>0) { tfs = ""+Period(); add=3; }
         
      for (int i=max; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[toInt(MathMin(max,i+add))],Period()));
                                                      return(Period());
}
//+-------------------------------------------------------------------
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
//+-------------------------------------------------------------------
string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
//+-------------------------------------------------------------------
//https://qiita.com/bucchi49/items/a08f240b920fc5f90a87
double iRCI(const string symbol, int timeframe, int period, int index)
{   
    int rank;
    double d = 0;
    double close_arr[];
    ArrayResize(close_arr, period); 

    for (int i = 0; i < period; i++) {
        close_arr[i] = iClose(symbol, timeframe, index + i);
    }

    ArraySort(close_arr, WHOLE_ARRAY, 0, MODE_DESCEND);

    for (int j = 0; j < period; j++) {
        rank = ArrayBsearch(close_arr,
                            iClose(symbol, timeframe, index + j),
                            WHOLE_ARRAY,
                            0,
                            MODE_DESCEND);
        d += MathPow(j - rank, 2);
    }

    return((1 - 6 * d / (period * (period * period - 1))) * 100);
}
//+-------------------------------------------------------------------
