
#property copyright "eevviill"
 #property link "http://volli7.blogspot.com/"
#property strict
#property version "1.0"
//#property icon "\\Files\\evi.ico"

#property indicator_chart_window


extern ENUM_BASE_CORNER info_corner = CORNER_RIGHT_UPPER;
extern string text_font = "Arrial";
extern int info_size = 10;
extern int info_X = 20;
extern int info_Y = 20;
extern int info_Y_step = 16; 

extern string Highest_equity = "Highest_equity";
extern bool Show_Highest_equity = true;
extern color Highest_equity_Color = clrOrange;

extern string Highest_lot = "Highest_lot";
extern bool Show_Highest_lot = true;
extern color Highest_lot_Color = clrCornflowerBlue;

extern string Max_floating_profit = "Max_floating_profit";
extern bool Show_Max_floating_profit = true;
extern color Max_floating_profit_Color = clrMediumOrchid;

extern string Max_floating_lose = "Max_floating_lose";
extern bool Show_Max_floating_lose = true;
extern color Max_floating_lose_Color = clrPaleGreen;


double equity_max;
double lot_max;
double floating_prof_max;
double floating_lose_max=EMPTY_VALUE;


////////////////
int OnInit()
  {
 equity_max=0;
 lot_max=0;
 floating_prof_max=0;
 floating_lose_max=EMPTY_VALUE;
 
  
IndicatorShortName("All in");


//Alert(MarketInfo(Symbol(),MODE_TICKVALUE));

    return(INIT_SUCCEEDED);

  }

///////////////////////////////////
void OnDeinit(const int reason)
{
 if(ObjectFind(Highest_equity)!=-1)         ObjectDelete(Highest_equity);
 if(ObjectFind(Highest_lot)!=-1)  ObjectDelete(Highest_lot);
 if(ObjectFind(Max_floating_profit)!=-1)       ObjectDelete(Max_floating_profit);
 if(ObjectFind(Max_floating_lose)!=-1)   ObjectDelete(Max_floating_lose);
 

   
 }



//////////////////////////////////
int OnCalculate(const int rates_total,const int prev_calculated,const datetime &time[],const double &open[],const double &high[],
                const double &low[],const double &close[],const long &tick_volume[],const long &volume[],const int &spread[])
  {  
int Yy=info_Y;

 if(Show_Highest_equity)         
 {
 if(AccountEquity()>equity_max) equity_max=AccountEquity();
 Draw_f(Highest_equity,DoubleToStr(equity_max,2),Yy,Highest_equity_Color); 
 Yy+=info_Y_step;
 }

 if(Show_Highest_lot)  
 {
 lot_max=lot_max_f();
 Draw_f(Highest_lot,DoubleToStr(lot_max,2),Yy,Highest_lot_Color);
 Yy+=info_Y_step;
 }
 ///
 double acc_prof=AccountProfit();
 if(Show_Max_floating_profit)         
 {
 if(acc_prof>floating_prof_max) floating_prof_max=acc_prof;
 Draw_f(Max_floating_profit,DoubleToStr(floating_prof_max,2),Yy,Max_floating_profit_Color);
 Yy+=info_Y_step;
 }
 
 if(Show_Max_floating_lose) 
 {
 if(acc_prof<floating_lose_max) floating_lose_max=acc_prof;
 Draw_f(Max_floating_lose,DoubleToStr(floating_lose_max,2),Yy,Max_floating_lose_Color);
 }



    return(rates_total);
  }




//draw func
////////////////////////////////////////////////////////////////////////
void Draw_f(string name,string object,int Y_distance, color Color)
{

if(ObjectFind(name)==-1)
{
ObjectCreate(0,name,OBJ_LABEL,0,0,0);
ObjectSetInteger(0,name,OBJPROP_CORNER,info_corner);
ObjectSetInteger(0,name, OBJPROP_XDISTANCE,info_X);
ObjectSetInteger(0,name, OBJPROP_YDISTANCE, Y_distance);
ObjectSetInteger(0,name, OBJPROP_FONTSIZE, info_size);
ObjectSetInteger(0,name, OBJPROP_COLOR, Color);
ObjectSetString(0,name, OBJPROP_FONT, text_font);
ObjectSetInteger(0,name,OBJPROP_ANCHOR,ANCHOR_RIGHT_UPPER);
   ObjectSetInteger(0,name,OBJPROP_SELECTABLE,false); 
   ObjectSetInteger(0,name,OBJPROP_SELECTED,false); 
   ObjectSetInteger(0,name,OBJPROP_HIDDEN,true); 
   ObjectSetInteger(0,name,OBJPROP_ZORDER,false); 
}
ObjectSetString(0,name,OBJPROP_TEXT,name+": "+object);

}

//////////////////////////////////////////////////
double lot_max_f()
{
double lot=0;


 for(int i=OrdersTotal()-1; i>=0; i--)
 {
   if(!OrderSelect(i,SELECT_BY_POS,MODE_TRADES)) continue;
   //if(OrderMagicNumber()!=Magic || OrderSymbol()!=Symbol()) continue;
   
 if(OrderLots()>lot) lot=OrderLots();
 }
 


return(lot);
}



 




