//+------------------------------------------------------------------+
//|                                                         3wpr.mq4 |
//|                                                  Victor Nicolaev |
//|                                                    vinin@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Victor Nicolaev aka Vinin"
#property link      "mailto: vinin@mail.ru"

#property indicator_separate_window
#property indicator_buffers SlateGray
#property indicator_color1 C'0,0,0'
#property indicator_color2 C'0,0,0'
#property indicator_color3 C'0,0,0'
#property indicator_color4 Maroon
#property indicator_color5 MidnightBlue
#property indicator_color6 DarkOliveGreen
#property indicator_color7 Silver

#property indicator_level1 0.5
#property indicator_level2 0
#property indicator_level3 -0.5
#property indicator_maximum 1
#property indicator_minimum -1
//---- input parameters

extern int CountBar1= 10;
extern int CountBar2= 40;
extern int CountBar3= 120;
extern int MACountBar1= 6;
extern int MACountBar2= 12;
extern int MACountBar3= 24;

//---- buffers
double ExtMapBuffer0[];
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
//---- drawing settings
   for (int i=0;i<7;i++) {
      SetIndexStyle(i,DRAW_LINE);
      SetIndexDrawBegin(i,MathMax(CountBar1,MathMax(CountBar2,CountBar3))+MACountBar1);
  }
   
      
   SetIndexBuffer(0,ExtMapBuffer0);      
   SetIndexBuffer(1,ExtMapBuffer1);
   SetIndexBuffer(2,ExtMapBuffer2);
   SetIndexBuffer(3,ExtMapBuffer3);
   SetIndexBuffer(4,ExtMapBuffer4);
   SetIndexBuffer(5,ExtMapBuffer5);
   SetIndexBuffer(6,ExtMapBuffer6);

   IndicatorShortName("Returns");
   
//---- initialization done
   return(0); }//int init() 
//+------------------------------------------------------------------+
int start() {
   int limit;
   int counted_bars=IndicatorCounted();
   int i;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if (limit>1440) limit = 14400;
   for (i = limit;i>=0;i--){
      ExtMapBuffer0[i] = Value(CountBar1,i);
      ExtMapBuffer1[i] = Value(CountBar2,i);
      ExtMapBuffer2[i] = Value(CountBar3,i);
   }
   for (i = limit;i>=0;i--){
      ExtMapBuffer3[i] = iMAOnArray(ExtMapBuffer0,0,MACountBar1,0,MODE_SMA,i);
      ExtMapBuffer4[i] = iMAOnArray(ExtMapBuffer1,0,MACountBar2,0,MODE_SMA,i);
      ExtMapBuffer5[i] = iMAOnArray(ExtMapBuffer2,0,MACountBar3,0,MODE_SMA,i);
      ExtMapBuffer6[i] = (ExtMapBuffer4[i]+ExtMapBuffer5[i])/2.0;
   }//(ExtMapBuffer3[i]+ExtMapBuffer4[i]+ExtMapBuffer5[i])/3.0;



   return(0); 
}// int start()

double Value(int CountBar, int pos) {
   double RetVal=0, tmpHigh, tmpLow;
   tmpHigh=High[iHighest(NULL,0,MODE_HIGH,CountBar,pos)];
   tmpLow=Low[iLowest(NULL,0,MODE_LOW,CountBar,pos)];
   if (tmpHigh>tmpLow) RetVal=((Close[pos]-tmpLow)/(tmpHigh-tmpLow)*2.0-1);
   return(RetVal);
}
   
   

