//+------------------------------------------------------------------+
//| 5 Min RSI 12-period qual INDICATOR                               |
//+------------------------------------------------------------------+
#property copyright "Ron T"
#property link      "http://www.lightpatch.com"

#property indicator_chart_window
#property indicator_buffers 4

#property indicator_color1 Red
#property indicator_color2 White
#property indicator_color3 Aqua
#property indicator_color4 LightGreen


//---- buffers
double Buffer1[];
double Buffer2[];
double Buffer3[];
double Buffer4[];



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//|------------------------------------------------------------------|

int init()
  {

   // 233 up arrow
   // 234 down arrow
   // 159 big dot
   // 158 little dot
   // 168 open square
   // 120 box with X
   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0, Buffer1);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1, Buffer2);

   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2, Buffer3);

   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3, Buffer4);

   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   int i;
   
   for( i=0; i<Bars; i++ ) Buffer1[i]=0;
   for( i=0; i<Bars; i++ ) Buffer2[i]=0;
   for( i=0; i<Bars; i++ ) Buffer3[i]=0;
   for( i=0; i<Bars; i++ ) Buffer4[i]=0;

   return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+


int start()
  {
   int      pos=Bars-100; // leave room for moving average periods
   int      ctr=0;

   double  ma1, ma2, ma3, ma4;
         
   double p=Point();
   
   while(pos>=0)
     {

      ma4= iMA(Symbol(),PERIOD_W1,4     ,0,PRICE_OPEN,MODE_SMA,pos);
      ma3= iMA(Symbol(),PERIOD_D1,20   ,0,PRICE_OPEN,MODE_SMA,pos);
      ma2= iMA(Symbol(),PERIOD_H4,20*6 ,0,PRICE_OPEN,MODE_SMA,pos);
      ma1= iMA(Symbol(),PERIOD_H1,20*24 ,0,PRICE_OPEN,MODE_SMA,pos);
      
      Buffer4[pos]=ma4;
      Buffer3[pos]=ma3;
      Buffer2[pos]=ma2;
      Buffer1[pos]=ma1;
      
 	   pos--;
     }

   return(0);
  }
//+------------------------------------------------------------------+