//+------------------------------------------------------------------+
//|                                                 3D Oscilator.mq4 |
//+------------------------------------------------------------------+
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers    2
#property indicator_color1     Yellow
#property indicator_color2     Red
#property indicator_levelcolor MediumOrchid

//
//
//
//
//

extern string TimeFrame        = "Current time frame";
extern int    D1RSIPer         = 13;
extern int    D2StochPer       = 8;
extern int    D3tunnelPer      = 8;
extern double hot              = 0.4;
extern int    sigsmooth        = 4;
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = false;
extern bool   alertsNotify     = false;
extern bool   alertsEmail      = false;
extern string soundFile        = "alert2.wav";
extern bool   ShowArrows       = false;
extern string arrowsIdentifier = "3D Osc Arrows1";
extern double arrowsUpperGap   = 0.10;
extern double arrowsLowerGap   = 0.10;
extern color  arrowsUpColor    = LimeGreen;
extern color  arrowsDnColor    = Red;
extern int    arrowsUpCode     = 241;
extern int    arrowsDnCode     = 242;
extern bool   Interpolate      = true;

//
//
//
//
//

double sig1n[];
double sig2n[];
double trend[];

//
//
//
//
//

string indicatorFileName;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(3);
   SetIndexBuffer(0,sig1n); 
   SetIndexBuffer(1,sig2n);
   SetIndexBuffer(2,trend);
   SetLevelValue(0,0);
    
    //
    //
    //
    //
    //
    
    indicatorFileName = WindowExpertName();
    returnBars        = TimeFrame == "returnBars";     if (returnBars)     return(0);
    timeFrame         = stringToTimeFrame(TimeFrame);
   
    //
    //
    //
    //
    //
    
    IndicatorShortName(timeFrameToString(timeFrame)+" 3D Oscilator");
return (0);
}
int deinit() 
{  
   deleteArrows(); 
return(0); 
}

//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { sig1n[0] = limit+1; return(0); }
            if (timeFrame!=Period())
            {
               limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
               for (int i=limit; i>=0; i--)
               {
                   int y = iBarShift(NULL,timeFrame,Time[i]);               
                      sig1n[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",D1RSIPer,D2StochPer,D3tunnelPer,hot,sigsmooth,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,0,y);
                      sig2n[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",D1RSIPer,D2StochPer,D3tunnelPer,hot,sigsmooth,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,ShowArrows,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,1,y);  
                      
                      //
                      //
                      //
                      //
                      //
                        
                      if (!Interpolate || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;

                      //
                      //
                      //
                      //
                      //

                      datetime time = iTime(NULL,timeFrame,y);
                      for(int n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;	
                      for(int x = 1; x < n; x++) 
                      {
                         sig1n[i+x] = sig1n[i] + (sig1n[i+n] - sig1n[i]) * x/n;
                         sig2n[i+x] = sig2n[i] + (sig2n[i+n] - sig2n[i]) * x/n; 
                      }             
               }
     return(0);
     }

     //
     //
     //
     //
     //
    
 	  for(i = limit; i >= 0; i--)
     {
        double cs = D1RSIPer+D2StochPer+D3tunnelPer+hot+sigsmooth;
        double ss = sigsmooth;
        if (ss<2) ss    = 2;
          double sk     = 2/(ss+1.0);
          double sk2    = 2/(ss*0.8+1.0);
          double rsi    = iRSI(NULL,0,D1RSIPer,PRICE_CLOSE,i);
          double maxrsi = rsi;
          double minrsi = rsi;
      
        //
        //
        //
        //
        //
      
        for (int j=i+D2StochPer; j>=i; j--)
        {
            rsi=iRSI(NULL,0,D1RSIPer,PRICE_CLOSE,j);
               if (rsi>maxrsi) maxrsi=rsi;
               if (rsi<minrsi) minrsi=rsi;
        }

        //
        //
        //
        //
        //

        if (maxrsi!=minrsi)      
           double storsi = ((rsi-minrsi)/(maxrsi-minrsi)*200-100);
        else      storsi = 0;         
        double E3D = hot*iCCI(NULL,0,D3tunnelPer,PRICE_TYPICAL,i)+(1-hot)*storsi;
         
        sig1n[i]=sk*E3D+(1-sk)*sig1n[i+1];
        sig2n[i]=sk2*sig1n[i+1]+(1-sk2)*sig2n[i+1];
        trend[i] = trend[i+1];
        if (sig1n[i]>sig2n[i]) trend[i] = 1;
        if (sig1n[i]<sig2n[i]) trend[i] =-1;
      
        //
        //
        //
        //
        //
      
        if (ShowArrows)
        {
          deleteArrow(Time[i]);
          if (trend[i] != trend[i+1])
          {
            if (trend[i] == 1)  drawArrow(i,arrowsUpColor,arrowsUpCode,false);
            if (trend[i] ==-1)  drawArrow(i,arrowsDnColor,arrowsDnCode, true);
          }
        }   
   }
   
   //
   //
   //
   //
   //
   
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      if (trend[whichBar] != trend[whichBar+1])
      if (trend[whichBar] == 1)
            doAlert("crossed up");
      else  doAlert("crossed down");       
   }       
return(0);
}
   
//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M10","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,10,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," 3D Oscilator ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," 3D Oscilator "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
     string name = arrowsIdentifier+":"+Time[i];
     double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}



