//+------------------------------------------------------------------+ 
//| ARSI.mq4 
//+------------------------------------------------------------------+ 
#property copyright "Alexander Kirilyuk M." 
#property link "" 

#property indicator_separate_window
//#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 DodgerBlue
#property indicator_color2 Yellow
#property indicator_color3 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2

extern string  TimeFrame   = "Current time frame";
extern int     ARSI1Period = 14;
extern int     ARSI2Period =  3;
extern int     ARSI3Period =  50;

//---- buffers 
double ARSI1[]; 
double ARSI2[]; 
double ARSI3[]; 
string indicatorFileName;
bool   returnBars;
int    timeFrame;

int init()
{ 
	SetIndexBuffer(0,ARSI1); 
	SetIndexBuffer(1,ARSI2);
   SetIndexBuffer(2,ARSI3); 
   indicatorFileName = WindowExpertName();
   returnBars        = TimeFrame == "returnBars";     if (returnBars)     return(0);
   timeFrame         = stringToTimeFrame(TimeFrame);
   IndicatorShortName(timeFrameToString(timeFrame)+" 2+1 RSI adaptive EMAs (" + ARSI1Period + "," + ARSI2Period+")");
	return(0); 
} 

int start() 
{ 
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { ARSI1[0] = limit+1; return(0); }
   
            if (timeFrame!=Period())
            {
               limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
               for (int i=limit; i>=0; i--)
               {
                   int y = iBarShift(NULL,timeFrame,Time[i]);            
                      ARSI1[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ARSI1Period,ARSI2Period,ARSI3Period,0,y);
                      ARSI2[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ARSI1Period,ARSI2Period,ARSI3Period,1,y);
                      ARSI3[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ARSI1Period,ARSI2Period,ARSI3Period,2,y);
               }
               return(0);
            }
	
	double sc;
	for(i = limit; i >= 0; i--)
	{
		sc = MathAbs(iRSI(NULL, 0, ARSI1Period, PRICE_CLOSE, i)/100.0 - 0.5) * 2.0;
		if( Bars - i <= ARSI1Period)
   			ARSI1[i] = Close[i];
		else	ARSI1[i] = ARSI1[i+1] + sc * (Close[i] - ARSI1[i+1]);
		sc = MathAbs(iRSI(NULL, 0, ARSI2Period, PRICE_CLOSE, i)/100.0 - 0.5) * 2.0;
		if( Bars - i <= ARSI2Period)
   			ARSI2[i] = Close[i];
		else	ARSI2[i] = ARSI2[i+1] + sc * (Close[i] - ARSI2[i+1]);
		sc = MathAbs(iRSI(NULL, 0, ARSI3Period, PRICE_CLOSE, i)/100.0 - 0.5) * 2.0;
		if( Bars - i <= ARSI3Period)
   			ARSI3[i] = Close[i];
		else	ARSI3[i] = ARSI3[i+1] + sc * (Close[i] - ARSI3[i+1]);
	}
	return(0); 
} 

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
return(s);
}




