//+------------------------------------------------------------------+
//|                                                    3rdCandle.mq4 |
//|                                                         CommGrow |
//|                                            http://www.google.com |
//|                                                                  |
//| modified by Fx.Tools @ forexfactory.com (added alert)            |
//+------------------------------------------------------------------+
#property copyright "Subu"
#property link      "http://www.google.com"
#property description "modified by Fx.Tools @ forexfactory.com (added alert)"
#property indicator_buffers 4
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_chart_window

double UpArrow[];
double DownArrow[];
double OpenBuy[];
double OpenSell[];
extern int ShiftArrow = -2;
extern bool FilterBullBearCandle = false;
extern bool ShowAlert = true;
extern bool ShowVLines = true;      // Show Vertical Lines
extern ENUM_LINE_STYLE LineStyle = STYLE_DOT; // Line Style
extern color LineColorBuy = clrDodgerBlue;   // Buy Line Color
extern color LineColorSell = clrOrangeRed;   // Sell Line Color
extern int LineWidth = 1;              // Line Width

datetime LastAlertTime;
long chartId = 0;
string sig = "[3rd]";

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, EMPTY,2);
   SetIndexArrow(0, 233);
   SetIndexBuffer(0, UpArrow);
   SetIndexEmptyValue(0,0.0);
   SetIndexShift(0,ShiftArrow);
   SetIndexStyle(1, DRAW_ARROW, EMPTY,2);
   SetIndexArrow(1, 234);
   SetIndexBuffer(1, DownArrow);
   SetIndexEmptyValue(1,0.0);
   SetIndexShift(1,ShiftArrow);
   SetIndexStyle(2, DRAW_NONE, STYLE_SOLID, 2);
   SetIndexArrow(2, 159);
   SetIndexBuffer(2, OpenBuy);
   SetIndexEmptyValue(2,0.0);
   SetIndexStyle(3, DRAW_NONE, STYLE_SOLID, 2);
   SetIndexArrow(3, 159);
   SetIndexBuffer(3, OpenSell);
   SetIndexEmptyValue(3,0.0);
   
   chartId = ChartID();
   
   LastAlertTime = TimeCurrent()-_Period*60;

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   // remove objects
   string objName = "";
   for (int i=ObjectsTotal(); i>=0; i--)
   {
      objName = ObjectName(chartId, i);
      if (StringFind(objName, sig)>=0) ObjectDelete(chartId, objName);
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int limit, i;
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
//----
    for(i = 0; i <= limit; i++) {
      DownArrow[i] = 0;
      UpArrow[i] = 0;
   if(High[i+2]>High[i+1] && Low[i+2]>Low[i+1] && High[i+2]>High[i+3] && Low[i+2]>Low[i+3])
      if( Open[i+1]>Close[i+1] && Close[i+2] > Close[i+1])
         if(FilterBullBearCandle)
            {
               if( Open[i+2]>Close[i+2])
                  DownArrow[i] = High[i+2] +0.0003;//Low[i+2] + (High[i+2]-Low[i+2]);
                  OpenSell[i] = Open[i];
             }
         else
         {
             DownArrow[i] = High[i+2] +0.0003;//Low[i+2] + (High[i+2]-Low[i+2]);
             OpenSell[i] = Open[i];
         }
   if(High[i+2]<High[i+1] && Low[i+2]<Low[i+1] && High[i+2]<High[i+3] && Low[i+2]<Low[i+3])
      if( Open[i+1]<Close[i+1] && Close[i+2] < Close[i+1])
          if(FilterBullBearCandle)
            {
               if( Open[i+2]<Close[i+2] ) 
               {
                  UpArrow[i] = Low[i+2] - 0.0003;//High[i+2] - (High[i+2]-Low[i+2]);
                  OpenBuy[i] = Open[i];
               }
            }
         else
         {
            UpArrow[i] = Low[i+2] - 0.0003;//High[i+2] - (High[i+2]-Low[i+2]);
            OpenBuy[i] = Open[i];
         }
      if (ShowVLines)
      {
         string objName = sig+IntegerToString((int)Time[i]);         
         if (NormalizeDouble(OpenBuy[i],Digits) > 0)
         {
            ObjectCreate(chartId, objName, OBJ_VLINE, 0, Time[i], 0);
            ObjectSetInteger(chartId, objName, OBJPROP_STYLE, LineStyle);
            ObjectSetInteger(chartId, objName, OBJPROP_WIDTH, LineWidth);
            ObjectSetInteger(chartId, objName, OBJPROP_COLOR, LineColorBuy);
            ObjectSetInteger(chartId, objName, OBJPROP_BACK, true);
         }
         else if (NormalizeDouble(OpenSell[i],Digits) > 0)
         {
            ObjectCreate(chartId, objName, OBJ_VLINE, 0, Time[i], 0);
            ObjectSetInteger(chartId, objName, OBJPROP_STYLE, LineStyle);
            ObjectSetInteger(chartId, objName, OBJPROP_WIDTH, LineWidth);
            ObjectSetInteger(chartId, objName, OBJPROP_COLOR, LineColorSell);
            ObjectSetInteger(chartId, objName, OBJPROP_BACK, true);
         }  
         else
         {
            ObjectDelete(chartId, objName);
         }
      }
   }
      
   int barIndex = 0-ShiftArrow;
   if (barIndex < 0) barIndex = 0;
   if (ShowAlert && Time[0] > LastAlertTime)
   {  
      string msg = "";
      if (NormalizeDouble(UpArrow[0],Digits) > 0)
      {
         msg = WindowExpertName()+" BUY signal for "+_Symbol+" on "+EnumToString((ENUM_TIMEFRAMES)_Period)+" at "+TimeToStr(Time[barIndex]);
         Alert(msg);
         LastAlertTime = Time[0];
      }
      else if (NormalizeDouble(DownArrow[0],Digits) > 0)
      {
         msg = WindowExpertName()+" SELL signal for "+_Symbol+" on "+EnumToString((ENUM_TIMEFRAMES)_Period)+" at "+TimeToStr(Time[barIndex]);
         Alert(msg);
         LastAlertTime = Time[0];
      }         
   }
      
//----
   return(0);
  }
//+-------------------------------------&-----------------------------+