
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Aqua
#property indicator_color2 Red

extern string TimeFrame        = "Current time frame";
extern int    NumberOfBarsInARow = 4;
extern string note             = "turn on Alert = true; turn off = false";
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = false;
extern bool   alertsMessage    = false;
extern bool   alertsSound      = false;
extern bool   alertsNotify     = false;
extern bool   alertsEmail      = false;
extern bool   ArrowsOnFirstBar = true;


double LongBuffer[];
double ShortBuffer[];
double trend[];
string indicatorFileName;
bool   returnBars;
int    timeFrame;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

int init() 
{
   IndicatorBuffers(3);
   SetIndexBuffer(0,LongBuffer);
   SetIndexStyle(0,DRAW_ARROW,EMPTY,2);
   SetIndexArrow(0,233);
   SetIndexBuffer(1,ShortBuffer);
   SetIndexStyle(1,DRAW_ARROW,EMPTY,2);
   SetIndexArrow(1,234);
   SetIndexBuffer(2,trend);
   indicatorFileName = WindowExpertName();
   returnBars        = TimeFrame == "returnBars";     if (returnBars)     return(0);
   timeFrame         = stringToTimeFrame(TimeFrame);
   
return(0);
  }

int deinit() 
{
   Comment("");
return(0);
}

int start()
{
  int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { LongBuffer[0] = limit+1; return(0); }
   
            if (timeFrame!=Period())
            {
               int shift = -1; if (ArrowsOnFirstBar) shift=1;
               limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
               for (int i=limit; i>=0; i--)
               {
                   int y = iBarShift(NULL,timeFrame,Time[i]);   
                   int x = iBarShift(NULL,timeFrame,Time[i+shift]);            
                      trend[i]      = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue","",NumberOfBarsInARow,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,2,y);
               if (x!=y)
               {
                      LongBuffer[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue","",NumberOfBarsInARow,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,0,y);
                      ShortBuffer[i]= iCustom(NULL,timeFrame,indicatorFileName,"calculateValue","",NumberOfBarsInARow,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,1,y);
                   
               }
             }
             return(0);
          }
  
  
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-1-counted_bars;
   
   for(i=limit; i>=0; i--)
   {
      LongBuffer[i]  = EMPTY_VALUE;
      ShortBuffer[i] = EMPTY_VALUE;
      trend[i]       = 0;
            int nbull = 0;
            int nbear = 0;
            for (int b=0; b<NumberOfBarsInARow; b++)
            {
                  if(Open[i+b]>Close[i+b]) nbear++;
                  if(Open[i+b]<Close[i+b]) nbull++;
            }
            if (nbear==NumberOfBarsInARow) { ShortBuffer[i]=High[i]; trend[i] = -1; }
            if (nbull==NumberOfBarsInARow) { LongBuffer[i] =Low[i];  trend[i] =  1; }
      Comment(nbear,"    ",nbull);
   }
   
   //
   //
   //
   //
   //
      
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (trend[whichBar] != trend[whichBar+1])
      if (trend[whichBar] == 1)
            doAlert("UP");
      else  doAlert("DOWN");       
   }
  return (0);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}

//
//
//
//
//

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," - ",timeFrameToString(timeFrame)+" "+NumberOfBarsInARow+"-in-row: ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(StringConcatenate(Symbol(), Period() ," 3 candles in a row  " +" "+message));
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," 3-in-row Alert "),message);
          if (alertsSound)   PlaySound("alert2.wav");
      }
}
      

