//+------------------------------------------------------------------+
//|                                                      2MA_RSI.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Wolfe"
#property link "forextsd.com"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1  20
#property indicator_level2  80
#property indicator_buffers 3
#property indicator_color1 Yellow
#property indicator_color2 Aqua
#property indicator_color3 MediumOrchid

extern int  RSI_Timeframe=0;//0=current chart,1=m1,5=m5,15=m15,30=m30,60=h1,240=h4,etc...
extern int  RSI_Period = 7;
extern int  RSI_Applied_Price = 0;//0=close, 1=open, 2=high, 3=low, 4=(high+low)/2, 5=(high+low+close)/3, 6=(high+low+close+close)/4
extern int  MA1_Period = 7;
extern int  MA1_Method = 1;// 0=SMA, 1=EMA, 2=SMMA, 3=LWMA
extern int  MA2_Period = 14;
extern int  MA2_Method = 1;// 0=SMA, 1=EMA, 2=SMMA, 3=LWMA

double MA1_Array[],MA2_Array[],RSI[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
{
//---- indicators setting
SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1);
SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,1);

IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
IndicatorShortName("2MA of RSI "+RSI_Timeframe);

SetIndexBuffer(0,MA1_Array);
SetIndexLabel(0,"MA1-RSI "+MA1_Period);

SetIndexBuffer(1,MA2_Array);
SetIndexLabel(1,"MA2-RSI "+MA2_Period);

SetIndexBuffer(2,RSI);
SetIndexLabel(2,"RSI "+RSI_Period);

return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function |
//+------------------------------------------------------------------+
int start()
{
int limit = Bars - IndicatorCounted() - 1;

//---- indicator calculation

   for(int i=limit; i>=0; i--)
   {
    RSI[i]= iRSI(NULL,RSI_Timeframe,RSI_Period,RSI_Applied_Price,i);
    
   }
    
   for(i=limit; i>=0; i--)
   { 
    MA1_Array[i] = iMAOnArray(RSI,0,MA1_Period,0,MA1_Method,i);
    MA2_Array[i] = iMAOnArray(RSI,0,MA2_Period,0,MA2_Method,i);
   }
//----
return(0);
}
//+------------------------------------------------------------------+